/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;

public class JmjController
extends Frame {
    private final int LOAD_FILE = 1;
    private final String QUIT = "quit";
    Jmj jmj;
    List list;
    Button juggle_button;
    Button pause_button;
    Button cancel_button;
    Label primarymessage;
    Label secondarymessage;
    Label motion_label;
    Label motion_value;
    Label ballno_label;
    Label ballno_value;
    Label pattern_label;
    Label pattern_value;
    Label speed_label;
    Scrollbar speed_gauge;
    Label speed_value;
    Label height_label;
    Scrollbar height_gauge;
    Label height_value;
    Label dwell_label;
    Scrollbar dwell_gauge;
    Label dwell_value;
    Label redrawrate_label;
    Scrollbar redrawrate_gauge;
    Label redrawrate_value;
    MenuBar mb;
    Menu menu_option;
    Menu menu_quit;
    JmjDialog jd;
    Label dialog_label = new Label();
    TextField dialog_text = new TextField();
    Button dialog_cancel = new Button("cancel");
    List dialog_motionlist = new List();
    Button dialog_ok = new Button("OK");
    Checkbox mirror_box;
    Checkbox ss_box;
    Checkbox body_box;
    int dialog_status;
    boolean cancel_flag = false;
    int prevIndex;

    public JmjController(Jmj jmj, String string) {
        super("Juggle Master java - Control Panel");
        this.jmj = jmj;
        this.resize(480, 470);
        this.setLayout(null);
        ((Component)this).setBackground(Color.white);
        this.setResizable(false);
        this.list = new List();
        this.list.reshape(270, 190, 200, 180);
        this.add(this.list);
        this.primarymessage = new Label();
        this.primarymessage.reshape(10, 400, 460, 20);
        this.add(this.primarymessage);
        this.secondarymessage = new Label();
        this.secondarymessage.reshape(10, 420, 460, 20);
        this.add(this.secondarymessage);
        this.juggle_button = new Button("juggle");
        this.juggle_button.reshape(50, 140, 100, 30);
        this.add(this.juggle_button);
        this.pause_button = new Button("pause");
        this.pause_button.reshape(190, 140, 100, 30);
        this.add(this.pause_button);
        this.cancel_button = new Button("stop/cancel");
        this.cancel_button.reshape(330, 140, 100, 30);
        this.add(this.cancel_button);
        this.pattern_label = new Label("pattern");
        this.pattern_label.reshape(10, 60, 100, 20);
        this.add(this.pattern_label);
        this.pattern_value = new Label("");
        this.pattern_value.reshape(120, 60, 300, 20);
        this.add(this.pattern_value);
        this.motion_label = new Label("arm motion");
        this.motion_label.reshape(10, 80, 100, 20);
        this.add(this.motion_label);
        this.motion_value = new Label("");
        this.motion_value.reshape(120, 80, 300, 20);
        this.add(this.motion_value);
        this.ballno_label = new Label("ball #");
        this.ballno_label.reshape(10, 100, 100, 20);
        this.add(this.ballno_label);
        this.ballno_value = new Label("");
        this.ballno_value.reshape(120, 100, 300, 20);
        this.add(this.ballno_value);
        this.speed_label = new Label("speed");
        this.speed_label.reshape(10, 190, 100, 20);
        this.add(this.speed_label);
        this.speed_gauge = new Scrollbar(0, 10, 3, 1, 23);
        this.speed_gauge.reshape(110, 190, 100, 20);
        this.add(this.speed_gauge);
        this.redrawrate_label = new Label("smoothness");
        this.redrawrate_label.reshape(10, 210, 100, 20);
        this.add(this.redrawrate_label);
        this.redrawrate_gauge = new Scrollbar(0, 50, 10, 20, 110);
        this.redrawrate_gauge.reshape(110, 210, 100, 20);
        this.add(this.redrawrate_gauge);
        this.redrawrate_value = new Label("");
        this.redrawrate_value.reshape(220, 210, 40, 20);
        this.add(this.redrawrate_value);
        this.speed_value = new Label("");
        this.speed_value.reshape(220, 190, 40, 20);
        this.add(this.speed_value);
        this.height_label = new Label("height");
        this.height_label.reshape(10, 230, 100, 20);
        this.add(this.height_label);
        this.height_gauge = new Scrollbar(0, 20, 15, 1, 115);
        this.height_gauge.reshape(110, 230, 100, 20);
        this.add(this.height_gauge);
        this.height_value = new Label("");
        this.height_value.reshape(220, 230, 40, 20);
        this.add(this.height_value);
        this.dwell_label = new Label("dwell ratio");
        this.dwell_label.reshape(10, 250, 100, 20);
        this.add(this.dwell_label);
        this.dwell_gauge = new Scrollbar(0, 20, 10, 10, 100);
        this.dwell_gauge.reshape(110, 250, 100, 20);
        this.add(this.dwell_gauge);
        this.dwell_value = new Label("");
        this.dwell_value.reshape(220, 250, 40, 20);
        this.add(this.dwell_value);
        this.mirror_box = new Checkbox("mirror image");
        this.mirror_box.reshape(50, 280, 150, 20);
        this.add(this.mirror_box);
        this.ss_box = new Checkbox("show siteswap");
        this.ss_box.reshape(50, 300, 180, 20);
        this.add(this.ss_box);
        this.body_box = new Checkbox("show juggler");
        this.body_box.reshape(50, 320, 180, 20);
        this.add(this.body_box);
        this.mb = new MenuBar();
        this.setMenuBar(this.mb);
        this.menu_quit = new Menu("quit");
        this.menu_quit.add(new MenuItem("quit"));
        if (string == null || !string.equalsIgnoreCase("true")) {
            this.mb.add(this.menu_quit);
        }
        this.menu_option = new Menu("option");
        this.menu_option.add(new MenuItem("load a pattern file"));
        this.menu_option.add(new MenuItem("try a new siteswap"));
        this.menu_option.add(new MenuItem("choose the motion"));
        this.mb.add(this.menu_option);
        this.validate();
        this.dialog_text.setFont(new Font("Dialog", 0, 15));
        this.dialog_cancel.resize(70, 20);
        this.dialog_ok.resize(70, 20);
        this.dialog_motionlist.resize(189, 190);
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.speed_gauge) {
            this.setSpeedLabel();
            return true;
        }
        if (event.target == this.height_gauge) {
            this.setHeightLabel();
            return true;
        }
        if (event.target == this.dwell_gauge) {
            this.setDwellLabel();
            return true;
        }
        if (event.target == this.redrawrate_gauge) {
            this.setRedrawrateLabel();
            return true;
        }
        if (event.target == this.list && event.id == 701) {
            this.chooseValidIndex();
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.list && event.id == 1001) {
            this.chooseValidIndex();
            this.juggle_pressed();
            return true;
        }
        if (event.target == this.juggle_button) {
            this.juggle_pressed();
            return true;
        }
        if (event.target == this.pause_button) {
            this.jmj.status = this.jmj.status == 0 ? 0 : (this.jmj.status == 1 ? 2 : 1);
            return true;
        }
        if (event.target == this.cancel_button) {
            if (this.jmj.status != 0) {
                this.jmj.stopJuggling();
                return true;
            }
            this.cancel_flag = true;
            return true;
        }
        if (event.target instanceof MenuItem) {
            if ("quit".equals((String)object)) {
                this.jmj.quit();
            }
            if ("load a pattern file".equals((String)object)) {
                this.disposeDialog();
                this.jd = new JmjDialog(this);
                this.jd.popup(1);
            }
            if ("try a new siteswap".equals((String)object)) {
                this.disposeDialog();
                this.jd = new JmjDialog(this);
                this.jd.popup(2);
            }
            if ("choose the motion".equals((String)object)) {
                try {
                    this.disposeDialog();
                    this.jd = new JmjDialog(this);
                    this.jd.popup(3);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            return true;
        }
        return super.action(event, object);
    }

    void juggle_pressed() {
        Jmj jmj = this.jmj;
        synchronized (jmj) {
            this.jmj.startJuggling(this.list.getSelectedIndex());
            return;
        }
    }

    boolean isCanceled() {
        try {
            boolean bl = this.cancel_flag;
            Object var3_2 = null;
            this.cancel_flag = false;
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cancel_flag = false;
            throw throwable;
        }
    }

    void setSpeedLabel() {
        this.speed_value.setText(String.valueOf(this.getSpeed()));
    }

    void setHeightLabel() {
        this.height_value.setText(String.valueOf(this.getHeight()));
    }

    void setDwellLabel() {
        this.dwell_value.setText(String.valueOf(this.getDwell()));
    }

    void setRedrawrateLabel() {
        this.redrawrate_value.setText(String.valueOf(this.getRedrawrate()));
    }

    void setLabels() {
        this.pattern_value.setText(this.jmj.pattern);
        this.ballno_value.setText(String.valueOf(this.jmj.ballno));
        this.motion_value.setText(this.jmj.motion);
    }

    void setSpeed(float f) {
        this.speed_gauge.setValue((int)(f * 10.0f));
        this.setSpeedLabel();
    }

    void setHeight(float f) {
        this.height_gauge.setValue((int)(f * 100.0f));
        this.setHeightLabel();
    }

    void setDwell(float f) {
        this.dwell_gauge.setValue((int)(f * 100.0f));
        this.setDwellLabel();
    }

    void setRedrawrate(float f) {
        this.redrawrate_gauge.setValue((int)f);
        this.setRedrawrateLabel();
    }

    float getSpeed() {
        return (float)this.speed_gauge.getValue() / 10.0f;
    }

    float getHeight() {
        return (float)this.height_gauge.getValue() / 100.0f;
    }

    float getDwell() {
        return (float)this.dwell_gauge.getValue() / 100.0f;
    }

    float getRedrawrate() {
        return this.redrawrate_gauge.getValue();
    }

    boolean ifShowBody() {
        return this.body_box.getState();
    }

    boolean ifShowSiteSwap() {
        return this.ss_box.getState();
    }

    boolean ifMirror() {
        return this.mirror_box.getState();
    }

    void setIfShowBody(boolean bl) {
        this.body_box.setState(bl);
    }

    void setIfShowSiteSwap(boolean bl) {
        this.ss_box.setState(bl);
    }

    void setIfMirror(boolean bl) {
        this.mirror_box.setState(bl);
    }

    boolean isNewChoice() {
        boolean bl = this.prevIndex != this.list.getSelectedIndex();
        this.prevIndex = this.list.getSelectedIndex();
        return bl;
    }

    void enableSwitches() {
        this.juggle_button.enable();
        this.pause_button.enable();
        this.list.enable();
    }

    void disableSwitches() {
        this.juggle_button.disable();
        this.pause_button.disable();
        this.list.disable();
    }

    void putMessage(String string, String string2) {
        this.putPrimaryMessage(string);
        this.putSecondaryMessage(string2);
    }

    void putPrimaryMessage(String string) {
        this.primarymessage.setText(string);
    }

    void putSecondaryMessage(String string) {
        this.secondarymessage.setText(string);
    }

    void chooseValidIndex() {
        int n = this.list.getSelectedIndex();
        while (n < this.list.countItems()) {
            if (this.jmj.holder.isPattern(n)) {
                this.list.select(n);
                return;
            }
            ++n;
        }
        n = this.list.getSelectedIndex();
        while (n > -1) {
            if (this.jmj.holder.isPattern(n)) {
                this.list.select(n);
                return;
            }
            --n;
        }
        this.list.deselect(this.list.getSelectedIndex());
    }

    void addPatternList(String string) {
        this.list.addItem(string);
    }

    void clearList() {
        this.list.clear();
    }

    void validatePatternList() {
        this.list.validate();
    }

    void enableMenuBar() {
        this.menu_option.enable();
        this.menu_quit.enable();
    }

    void disableMenuBar() {
        this.menu_option.disable();
        this.menu_quit.enable();
    }

    void disposeDialog() {
        if (this.jd != null) {
            ((Component)this.jd).hide();
            this.jd.dispose();
            this.jd = null;
        }
    }

    static class JmjDialog
    extends Dialog {
        public static final String STRING_LOAD = "load a pattern file";
        public static final String STRING_SITESWAP = "try a new siteswap";
        public static final String STRING_MOTION = "choose the motion";
        public static final int LOAD_FILE = 1;
        public static final int TRY_SITESWAP = 2;
        public static final int CHOOSE_MOTION = 3;
        private int status;
        JmjController jc;
        private List motionlist;
        private Label label;
        private Button ok;
        private Button cancel;
        private TextField text;

        JmjDialog(JmjController jmjController) {
            super((Frame)jmjController, false);
            this.setLayout(null);
            this.jc = jmjController;
            this.motionlist = this.jc.dialog_motionlist;
            this.label = this.jc.dialog_label;
            this.ok = this.jc.dialog_ok;
            this.cancel = this.jc.dialog_cancel;
            this.text = this.jc.dialog_text;
            this.add(this.ok);
            this.add(this.cancel);
            this.add(this.label);
            ((Component)this).hide();
        }

        void popup(int n) {
            this.status = n;
            switch (this.status) {
                case 1: {
                    this.resize(400, 160);
                    this.add(this.text);
                    this.label.setText("type in URL or filename to load");
                    ((TextComponent)this.text).setText(String.valueOf(this.jc.jmj.getCodeBase()));
                    this.label.reshape(10, 30, 380, 20);
                    this.text.reshape(10, 60, 380, 25);
                    this.ok.move(100, 100);
                    this.cancel.move(230, 100);
                    this.validate();
                    this.show();
                    return;
                }
                case 2: {
                    this.resize(600, 260);
                    this.add(this.text);
                    this.add(this.motionlist);
                    this.label.setText("Type in a siteswap, and choose the motion if you like");
                    ((TextComponent)this.text).setText(new String());
                    this.makeMotionlist();
                    this.motionlist.reshape(410, 30, 180, 190);
                    this.label.reshape(10, 30, 380, 20);
                    this.text.reshape(10, 60, 380, 30);
                    this.cancel.move(230, 120);
                    this.ok.move(100, 120);
                    this.validate();
                    this.show();
                    return;
                }
                case 3: {
                    this.resize(200, 310);
                    this.jc.jmj.stopJuggling();
                    this.add(this.motionlist);
                    this.label.setText("Choose the motion");
                    this.makeMotionlist();
                    this.label.reshape(5, 30, 190, 20);
                    this.motionlist.reshape(5, 60, 190, 180);
                    this.cancel.move(110, 250);
                    this.ok.move(20, 250);
                    this.validate();
                    this.show();
                    return;
                }
            }
        }

        public boolean action(Event event, Object object) {
            switch (this.status) {
                case 1: {
                    if (event.target != this.text && event.target != this.ok) break;
                    ((Component)this).hide();
                    if (this.text.getText().length() != 0 && !this.text.getText().equals(String.valueOf(this.jc.jmj.getCodeBase()))) {
                        this.jc.jmj.openFile(this.text.getText());
                    }
                    return true;
                }
                case 2: {
                    if (event.target != this.ok && event.target != this.text) break;
                    ((Component)this).hide();
                    if (this.text.getText().length() != 0) {
                        this.jc.jmj.motion = this.motionlist.getSelectedIndex() != -1 ? this.motionlist.getSelectedItem() : "Normal";
                        int n = this.jc.list.getSelectedIndex();
                        if (n != -1) {
                            this.jc.list.deselect(n);
                            this.jc.isNewChoice();
                        }
                        Jmj jmj = this.jc.jmj;
                        synchronized (jmj) {
                            this.jc.jmj.startJuggling(-3, this.text.getText());
                        }
                    }
                    return true;
                }
                case 3: {
                    if (event.target != this.motionlist && event.target != this.ok) break;
                    ((Component)this).hide();
                    Jmj jmj = this.jc.jmj;
                    synchronized (jmj) {
                        this.jc.jmj.startJuggling(-2, this.motionlist.getSelectedItem());
                    }
                    return true;
                }
            }
            if (event.target == this.cancel) {
                ((Component)this).hide();
                return true;
            }
            return super.action(event, object);
        }

        void quickSort(int n, int n2) {
            if (n >= n2) {
                return;
            }
            this.swap(n, (n + n2) / 2);
            int n3 = n;
            int n4 = n + 1;
            while (n4 <= n2) {
                if (this.motionlist.getItem(n4).compareTo(this.motionlist.getItem(n)) < 0) {
                    this.swap(++n3, n4);
                }
                ++n4;
            }
            this.swap(n3, n);
            this.quickSort(n, n3 - 1);
            this.quickSort(n3 + 1, n2);
        }

        void swap(int n, int n2) {
            String string = this.motionlist.getItem(n);
            this.motionlist.replaceItem(this.motionlist.getItem(n2), n);
            this.motionlist.replaceItem(string, n2);
        }

        void makeMotionlist() {
            if (this.jc.jmj.holder.countMotions() > this.motionlist.countItems()) {
                String string;
                this.motionlist.clear();
                while ((string = this.jc.jmj.holder.nextMotion()).length() != 0) {
                    this.motionlist.addItem(string);
                }
                this.quickSort(0, this.motionlist.countItems() - 1);
            }
        }
    }
}

